/*** 1.   ũƮ ***/

SELECT *, CONVERT(INT, RIGHT(num,1)) AS code 
INTO TB_DATA11
FROM (SELECT 
          ROW_NUMBER() OVER (ORDER BY A.number) AS num 
        , LEFT(CONVERT(CHAR(8), DATEADD(HH, A.number,'2020-01-01'), 112), 6) AS date
	FROM master..spt_values A, (SELECT NUMBER 
				  FROM master..spt_values B
				  WHERE type = 'P' AND number <= 500) B
	WHERE A.type = 'P' 
) C

SELECT number AS id, number +2 AS code
INTO TB_CODE
FROM master..spt_values B 
WHERE type = 'P' AND number between 1 and 10 

CREATE INDEX NIDX01_DATA11 ON TB_DATA11(code,date)
CREATE INDEX NIDX01_CODE ON TB_CODE(code)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT A.code 
FROM TB_CODE A INNER JOIN TB_DATA11 B  
ON A.code=B.code
AND B.date >'20200101'
GROUP BY A.code 
ORDER BY A.code
GO


/*** 6. [TO-BE]   ***/

SELECT A.code
FROM TB_CODE A
WHERE EXISTS (SELECT '1' 
		FROM TB_DATA11 B 
		WHERE A.code=B.code
		AND B.DATE >'20200101')
GROUP BY A.code
ORDER BY A.code
GO


